using System;
using System.Diagnostics;
using System.Runtime.Serialization;

namespace Team_Project.Elements
{
	[Serializable]
	public class ValueLockElement: ISerializable
	{
		public LockElement realElement;
		protected ValueLockElement(SerializationInfo info, StreamingContext context)
		{
			realElement = new LockElement(info);
			Trace.WriteLine("Lock deserialized: " + realElement.ToString());
		}
		public ValueLockElement(LockElement el)
		{
			realElement = el;
		}
		#region ISerializable Members

		public void GetObjectData(SerializationInfo info, StreamingContext context)
		{
			realElement.Serialize(info);
			Trace.WriteLine("Lock serialized: " + realElement.ToString());
		}

		#endregion
	}
}
